/******************************************************************************
													            Copyright (c) Freescale 2006
File Name    : $RCSfile: main.h,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
DESCRIPTION:  header file for main.c                                            
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r32151    01/03/05    - initial coding              

     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/
#ifndef MAIN_H       
#define MAIN_H

/************************* typedefs ******************************************/
/* Note: word / long elements of stuctures for access by XGate should have   */
/* even size i.e. on even boundary and all XGate pointers are 16-bit.        */

/************************* #defines ******************************************/
#define CHECKSUM_OK 					0x80		/* Valid checksum response - transmitted if calculated checksum matches received value */
#define CHECKSUM_BAD					0x01		/* Bad checksum response */ 

#define SCI_READY 				0x55		/* Sent when application is loaded successfuly */
#define SCI_ACK 				0xaa		/* Sent when application is loaded successfuly */
#define SCI_LINE_LENGTH          1     /* SCI Rx state machine control */
#define SCI_START_GPAGE          2     /* SCI Rx state machine control */
#define SCI_START_ADDR_MSB			3			/* SCI Rx state machine control */
#define SCI_START_ADDR_LSB			4			/* SCI Rx state machine control */
#define SCI_DATA_BYTE				5			/* SCI Rx state machine control */
#define SCI_CHECKSUM_BYTE			6			/* SCI Rx state machine control */



#define CAN_EXECUTE_ID				0x0200	/* CAN ID 0x010 (<< 5) - 11 bit ID on MSCAN is left justified, hence the shifts */
#define CAN_ADDRESS_POINTER_ID 	0x0400	/* CAN ID 0x200 (<< 5) */
#define CAN_LOAD_DATA_ID			0x0800	/* CAN ID 0x040 (<< 5) */
#define CAN_CHECKSUM_VALUE_ID		0x1000	/* CAN ID 0x080 (<< 5) */
#define CAN_CHECKSUM_STATUS_ID  	0xC000	/* CAN ID 0x600 (<< 5) */
#define ACCEPT_ALL_MASK				0xFFFFFFFFL	/* CAN Acceptance mask to accept all CAN identifiers */  

/* Device selection is in "projectglobals.h" */
/* SCI0_PRESENT is implicit as there is always expected to be an SCI0 module */


#define XEx100
													/* Devices with 3 CAN & 2 SCI modules */
#ifdef XEx100             /* device is Dx512            */		
#include "per_XEx100_M22E.h"
	#define CAN0_PRESENT
	#define CAN1_PRESENT
	#define CAN4_PRESENT
	#define SCI1_PRESENT
	#define SCI2_PRESENT
#endif

#define SystemCall asm sys

#endif /* MAIN_H */  